/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xmasdefs.h 
 *       Type Definitions for Requester-Initiator (RI) Functions
 * -----------------------------------------------------------------*/

#ifndef XRIDEFS_H_INCLUDED                               
#define XRIDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif

/********************************************************************
  RI generics *******************************************************
********************************************************************/

#define BX_RIGENPROP_SIZE         23

CLI typedef enum {
  BX_RIGEN_NUMBLK,       /* @numblk    */
  BX_RIGEN_REPEATBLK,    /* @repeatblk */
  BX_RIGEN_NUMBEH,       /* @numbeh    */
  BX_RIGEN_NUMBEHG0,     /* @numbehg0  */
  BX_RIGEN_NUMBEHG1,     /* @numbehg1  */
  BX_RIGEN_NUMBEHG2,     /* @numbehg2  */
  BX_RIGEN_NUMBEHG3,     /* @numbehg3  */
  BX_RIGEN_NUMBEHG4,     /* @numbehg4  */
  BX_RIGEN_NUMBEHG5,     /* @numbehg5  */
  BX_RIGEN_NUMBEHG6,     /* @numbehg6  */
  BX_RIGEN_NUMBEHG7,     /* @numbehg7  */
  BX_RIGEN_NUMBEHG8,     /* @numbehg8  */
  BX_RIGEN_NUMBEHG9,     /* @numbehg9  */
  BX_RIGEN_SKIPREG1,     /* @skipreg1  */
  BX_RIGEN_SKIPREG2,     /* @skipreg2  */
  BX_RIGEN_SKIPREG3,     /* @skipreg3  */
  BX_RIGEN_SKIPREG4,     /* @skipreg4  */
  BX_RIGEN_SKIPREG5,     /* @skipreg5  */
  BX_RIGEN_SKIPREG6,     /* @skipreg6  */
  BX_RIGEN_SKIPREG7,     /* @skipreg7  */
  BX_RIGEN_TABORT,       /* @tabort    */
  BX_RIGEN_IABORT,       /* @iabort    */
  BX_RIGEN_MENABLE       /* @menable   */
} bx_rigentype;

CLI  /* DEF_START ~G_BX_RIGEN_RETRY */
#define BX_RIGEN_RETRY_POSTPONE 0xffffffff
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_RIGEN_REPEATBLK */
#define BX_RIGEN_REPEATBLK_INFINITE 0
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_RIGEN_TRIGCMP */
#define BX_RIGEN_TRIGCMP_STOP 0
#define BX_RIGEN_TRIGCMP_CONT 1
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_RIGEN_TABORT */
#define BX_RIGEN_TABORT_STOP  0
#define BX_RIGEN_TABORT_SKIP  1
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_RIGEN_IABORT */
#define BX_RIGEN_IABORT_STOP  0
#define BX_RIGEN_IABORT_SKIP  1
CLI  /* DEF_END */


/********************************************************************
  RI block ******************************************************
********************************************************************/

#define BX_RIBLOCKPROP_SIZE          14

CLI typedef enum {
  BX_RIBLK_BUSADDR_LO,  /* @busaddrlo   */
  BX_RIBLK_BUSADDR_HI,  /* @busaddrhi   */
  BX_RIBLK_BUSCMD,      /* @buscmd      */
  BX_RIBLK_BYTEN,       /* @byten       */
  BX_RIBLK_INTADDR,     /* @intaddr     */
  BX_RIBLK_NUMBYTES,    /* @numbytes    */
  BX_RIBLK_CONDSTART,   /* @condstart   */
  BX_RIBLK_COMPLETION,  /* @completion  */
  BX_RIBLK_RELAXORDER,  /* @relaxorder  */
  BX_RIBLK_NOSNOOP,     /* @nosnoop     */
  BX_RIBLK_RESERVED31,  /* @reserved31  */
  BX_RIBLK_QUEUE,       /* @queue       */
  BX_RIBLK_RESOURCE,    /* @resource    */
  BX_RIBLK_DATACMP      /* @datacmp     */
} bx_riblktype;

CLI  /* DEF_START ~G_BX_RIBLK_RESOURCE */ 
#define BX_RIBLK_RESOURCE_DATAMEM 0  /* @DataMem */
#define BX_RIBLK_RESOURCE_DATAGEN 1  /* @DataGen */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_RIBLK_DATACMP */
#define BX_RIBLK_DATACMP_OFF      0  /* @Off */
#define BX_RIBLK_DATACMP_ON       1  /* @On */
CLI  /* DEF_END */

/*-----------------------------------------------------------------------------
 * note: both bx_riblk_buscmd and bx_buscmd can be used.
 * TODO: find other places where pci-x cmds are defined!!!
 *---------------------------------------------------------------------------*/
CLI /* DEF_START ~G_BX_RIBLK_BUSCMD */
#define BX_BUSCMD_INTACK               0x0    /* @IntAck        */
#define BX_BUSCMD_SPECIAL              0x1    /* @Special       */
#define BX_BUSCMD_IO_READ              0x2    /* @IoRead        */
#define BX_BUSCMD_IO_WRITE             0x3    /* @IoWrite       */
#define BX_BUSCMD_RESERVED4            0x4    /* @Reserved4     */
#define BX_BUSCMD_DEVID_MSG            0x5    /* @DevIdMsg      */
#define BX_BUSCMD_MEM_READDWORD        0x6    /* @MemReadDWord  */
#define BX_BUSCMD_MEM_WRITE            0x7    /* @MemWrite      */
#define BX_BUSCMD_ALIAS_MEM_READBLOCK  0x8    /* @AliasMemReadBlock  */
#define BX_BUSCMD_ALIAS_MEM_WRITEBLOCK 0x9    /* @AliasMemWriteBlock */
#define BX_BUSCMD_CONFIG_READ          0xa    /* @ConfigRead       */
#define BX_BUSCMD_CONFIG_WRITE         0xb    /* @ConfigWrite   */
#define BX_BUSCMD_SPLIT                0xc    /* @Split         */
#define BX_BUSCMD_DAC                  0xd    /* @Dac           */
#define BX_BUSCMD_MEM_READBLOCK        0xe    /* @MemReadBlock  */
#define BX_BUSCMD_MEM_WRITEBLOCK       0xf    /* @MemWriteBlock */

#define BX_RIBLK_BUSCMD_INTACK                    BX_BUSCMD_INTACK
#define BX_RIBLK_BUSCMD_SPECIAL                   BX_BUSCMD_SPECIAL
#define BX_RIBLK_BUSCMD_IO_READ                   BX_BUSCMD_IO_READ
#define BX_RIBLK_BUSCMD_IO_WRITE                  BX_BUSCMD_IO_WRITE
#define BX_RIBLK_BUSCMD_RESERVED4                 BX_BUSCMD_RESERVED4
#define BX_RIBLK_BUSCMD_DEVID_MSG                 BX_BUSCMD_DEVID_MSG
#define BX_RIBLK_BUSCMD_MEM_READDWORD             BX_BUSCMD_MEM_READDWORD
#define BX_RIBLK_BUSCMD_MEM_WRITE                 BX_BUSCMD_MEM_WRITE
#define BX_RIBLK_BUSCMD_ALIAS_MEM_READBLOCK       BX_BUSCMD_ALIAS_MEM_READBLOCK
#define BX_RIBLK_BUSCMD_ALIAS_MEM_WRITEBLOCK      BX_BUSCMD_ALIAS_MEM_WRITEBLOCK
#define BX_RIBLK_BUSCMD_CONFIG_READ               BX_BUSCMD_CONFIG_READ
#define BX_RIBLK_BUSCMD_CONFIG_WRITE              BX_BUSCMD_CONFIG_WRITE
#define BX_RIBLK_BUSCMD_SPLIT                     BX_BUSCMD_SPLIT
#define BX_RIBLK_BUSCMD_DAC                       BX_BUSCMD_DAC
#define BX_RIBLK_BUSCMD_MEM_READBLOCK             BX_BUSCMD_MEM_READBLOCK
#define BX_RIBLK_BUSCMD_MEM_WRITEBLOCK            BX_BUSCMD_MEM_WRITEBLOCK
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_RIBLK_CONDSTART */
#define BX_RIBLK_CONDSTART_NO         0 /* @No    */
#define BX_RIBLK_CONDSTART_ONCE1      2 /* @Once1 */
#define BX_RIBLK_CONDSTART_WAIT1      3 /* @Wait1 */
#define BX_RIBLK_CONDSTART_ONCE2      4 /* @Once2 */
#define BX_RIBLK_CONDSTART_WAIT2      5 /* @Wait2 */
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_RIBLK_QUEUE */
#define BX_RIBLK_QUEUE_A          1 /* @qa     */
#define BX_RIBLK_QUEUE_B          2 /* @qb     */
#define BX_RIBLK_QUEUE_AUTO       3 /* @qauto   */
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_RIBLK_BYTEN */
#define BX_RIBLK_BYTEN_ALL      0x0UL /* @All */
#define BX_RIBLK_BYTEN_DWORD0   0x0UL /* @DWord0 */
#define BX_RIBLK_BYTEN_NONE     0xfUL /* @None */
#define BX_RIBLK_BYTEN_BYTE0    0xeUL /* @Byte0 */
#define BX_RIBLK_BYTEN_BYTE1    0xdUL /* @Byte1 */
#define BX_RIBLK_BYTEN_BYTE2    0xbUL /* @Byte2 */
#define BX_RIBLK_BYTEN_BYTE3    0x7UL /* @Byte3 */
#define BX_RIBLK_BYTEN_WORD0    0xcUL /* @Word0 */
#define BX_RIBLK_BYTEN_WORD1    0x3UL /* @Word1 */
CLI /* DEF_END */

CLI typedef enum {
  BX_RIBLKGRP_0,
  BX_RIBLKGRP_1,
  BX_RIBLKGRP_2,
  BX_RIBLKGRP_3,
  BX_RIBLKGRP_4,
  BX_RIBLKGRP_ENUMSIZE     /* $enumsize */
} bx_rigrouptype;

#define BX_RIBLKGRP_SIZE BX_RIBLKGRP_ENUMSIZE

/********************************************************************
  RI behavior *******************************************************
********************************************************************/

/* Caution:
   If you add or remove a property here or change its group,
   do not forget to adjust files dynamic.c and prp_matt.c
   (function Prop2Group()) also.
 */ 

CLI typedef enum {
  BX_RIBEH_QUEUE,         /* @queue      */  /* Group 3 */
  BX_RIBEH_TAG,           /* @tag        */  /* Group 3 */
  BX_RIBEH_BYTECOUNT,     /* @bytecount  */  /* Group 3 */
  BX_RIBEH_DISCONNECT,    /* @disconnect */  /* Group 2 */
  BX_RIBEH_DELAY,         /* @delay      */  /* Group 1 */
  BX_RIBEH_STEPS,         /* @steps      */  /* Group 3 */
  BX_RIBEH_REQ64,         /* @req64      */  /* Group 3 */
  BX_RIBEH_RELREQ,        /* @relreq     */  /* Group 1 */
  BX_RIBEH_REPEAT,        /* @repeat     */  /* Group 0 */
  BX_RIBEH_SKIP,          /* @skip       */  /* Group 3 */
  BX_RIBEH_ENUMSIZE       /* $enumsize */
} bx_ribehtype;
    
#define BX_RIBEHPROP_SIZE    ((bx_int32) BX_RIBEH_ENUMSIZE)

CLI  /* DEF_START ~G_BX_RIBEH_QUEUE */    
#define BX_RIBEH_QUEUE_NEXT 3       /* @Next */
#define BX_RIBEH_QUEUE_A    1       /* @qa    */
#define BX_RIBEH_QUEUE_B    2       /* @qb    */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_RIBEH_TAG */  
#define BX_RIBEH_TAG_AUTO  32       /* @Auto */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_RIBEH_DISCONNECT */
#define BX_RIBEH_DISCONNECT_NO 0    /* @No */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_RIBEH_SKIP */
#define BX_RIBEH_SKIP_NO 0         /* @No */
CLI  /* DEF_END */

/********************************************************************
  RI behavior groups ********************************************
********************************************************************/

CLI typedef enum {
  BX_RIBEHGRP_0 = 1UL << 0UL, /* @ribehgrp0 */
  BX_RIBEHGRP_1 = 1UL << 1UL, /* @ribehgrp1 */
  BX_RIBEHGRP_2 = 1UL << 2UL, /* @ribehgrp2 */
  BX_RIBEHGRP_3 = 1UL << 3UL, /* @ribehgrp3 */
  BX_RIBEHGRP_4 = 1UL << 4UL, /* @ribehgrp4 */
  BX_RIBEHGRP_5 = 1UL << 5UL, /* @ribehgrp5 */
  BX_RIBEHGRP_6 = 1UL << 6UL, /* @ribehgrp6 */
  BX_RIBEHGRP_7 = 1UL << 7UL, /* @ribehgrp7 */
  BX_RIBEHGRP_8 = 1UL << 8UL, /* @ribehgrp8 */
  BX_RIBEHGRP_9 = 1UL << 9UL, /* @ribehgrp8 */
  BX_RIBEHGRP_ENUMSIZE        /* $enumsize */
} bx_ribehgrptype;

#define BX_RIBEHGRP_SIZE 9
   
#endif
